#! /bin/bash
# Wing FTP Software 2003-2024 wftpserver.com All Rights Reserved 
# Wing Gateway setup script for Linux

portvalid="0"
adminport="7466"
password=""

INITD_WGATEWAY="/etc/init.d/wgateway"
SYSTEMD_WGATEWAY="/etc/systemd/system/wgateway.service"

APPNAME="$0"
while [ -h "$APPNAME" ]; do
        LINK=`ls -ld "$APPNAME"`
        LINK=`expr "$LINK" : '.*-> \(.*\)'`
        if [ "`expr "$link" : '/.*'`" = 0 ]; then
                DIR=`dirname "$APPNAME"`
                APPNAME="$DIR/$LINK"
        else
                APPNAME="$LINK"
        fi
done
WING_HOME=`dirname $APPNAME`
WING_HOME=`cd $WING_HOME && pwd`


alert() {
	echo -n "$1? [y/N]: "
	read MESSAGE
	expr "$MESSAGE" : ' *[yY].*' > /dev/null
}


if [ "$UID" -ne "0" ]; then
  echo "The setup script is required to run under root privileges."
  echo "Please try again like this:  sudo ./setup.sh"
  exit
fi


echo "Welcome to Wing Gateway setup wizard!"
echo "Please setup Gateway communication password first."
echo "This password is very important as it will be used to connect from Wing FTP Server."
echo -n "Enter your Gateway password: "
read strPassword
while [ -z "$strPassword" ] || [ "`expr length $strPassword`" -lt "8" ]; do
   echo "Gateway password must have 8 or more characters!"
   echo ""
   echo -n "Enter your Gateway password: "
   read strPassword
done

password="<![CDATA[$strPassword]]>"

echo ""
echo "Select a port for communication between Wing FTP Server and Wing Gateway."
echo -n "Enter the listener port (default is 7466): "
read adminport
if [ -z "$adminport" ]; then
    adminport="7466"
fi


#check whether adminport is a valid port
netstat -ln |awk '/^tcp/ {print $4}' |grep -q ":$adminport$" || portvalid="1" 1>/dev/null 2>&1
echo "$adminport" |grep -Eq '[^0-9]' && portvalid="0" 1>/dev/null 2>&1
while [ -z "$adminport" ] || [ "$portvalid" -eq "0" ] || [ "$adminport" -lt "1" ] || [ "$adminport" -gt "65535" ]; do
    echo "Port $adminport is an invalid port or being used by Wing Gateway (or other application), please stop Wing Gateway first."
    echo ""
    echo -n "Enter the listener port(default is 7466): "
    read adminport
    if [ -z "$adminport" ]; then
        adminport="7466"
    fi
    portvalid="0"
    netstat -ln |awk '/^tcp/ {print $4}' |grep -q ":$adminport$" || portvalid="1" 1>/dev/null 2>&1
    echo "$adminport" |grep -Eq '[^0-9]' && portvalid="0" 1>/dev/null 2>&1
done


#kill the existed WingGateway process
pkill WingGateway & 1>/dev/null 2>&1


if [ ! -f "$WING_HOME/settings.xml" ]; then
touch "$WING_HOME/settings.xml"
cat > "$WING_HOME/settings.xml" <<-EOF
<?xml version="1.0"?>
<WingGateway>
	<Password>$password</Password>
	<ListenerPort>$adminport</ListenerPort>
	<ListenerAddress>*</ListenerAddress>
	<LogFilePath>Log</LogFilePath>
	<FailoverTimer>30</FailoverTimer>
	<ListenerTimeout>20</ListenerTimeout>
	<CompressOldLog>1</CompressOldLog>
</WingGateway>
EOF
fi

sed -i -e "s/\(<ListenerPort>\).*\(<\/ListenerPort>\)/\1$adminport\2/" "$WING_HOME/settings.xml"

Replacement=$(printf '%s\n' "$password" | sed 's/[\&/]/\\&/g')
sed -i -e "s/\(<Password>\).*\(<\/Password>\)/\1$Replacement\2/" "$WING_HOME/settings.xml"

if [ -f "$WING_HOME/settings.xml" ]; then
	chmod 600 "$WING_HOME/settings.xml"
fi

if [ -f "$WING_HOME/license.dat" ]; then
	chmod 600 "$WING_HOME/license.dat"
fi


if [ -d "/etc/systemd/system" ]; then
cat > "$SYSTEMD_WGATEWAY" <<-EOF
[Unit]
Description=Wing Gateway daemon
After=network.target

[Service]
User=root
Group=root
Type=forking
ExecStart=/etc/init.d/wgateway start
ExecStop=/etc/init.d/wgateway stop
WorkingDirectory=$WING_HOME

[Install]
WantedBy=multi-user.target
EOF

touch "$SYSTEMD_WGATEWAY"
chmod +x "$SYSTEMD_WGATEWAY"
systemctl enable wgateway.service 1>/dev/null 2>&1
systemctl daemon-reload 1>/dev/null 2>&1
fi

if [ ! -d "/etc/init.d" ]; then
mkdir -p "/etc/init.d" 1>/dev/null 2>&1
fi

cat > "$INITD_WGATEWAY" <<-EOF
#!/bin/sh
# Startup script for Wing Gateway

### BEGIN INIT INFO
# Provides:          WingGateway
# Required-Start:    $local_fs $syslog
# Required-Stop:     $local_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start daemon at boot time
# Description:       Enable service provided by daemon.
### END INIT INFO

start()
{
    echo "Starting Wing Gateway daemon..."
    cd $WING_HOME
    ulimit -c unlimited
    ulimit -n 65535
    ./WingGateway & 1>/dev/null 2>&1
    echo "Wing Gateway Started."
    exit 0
}
stop()
{
    echo "Stopping Wing Gateway daemon..."
    #pkill WingGateway & 1>/dev/null 2>&1
    GATEWAY_PID=\`ps -ef | grep \\.\\/WingGateway | grep -v grep | grep -v service | grep -v init.d | awk '{print \$2}'\`
    if [ ! -z "\$GATEWAY_PID" ]; then
       kill -9 \$GATEWAY_PID & 1>/dev/null 2>&1
    fi
    echo "Wing Gateway Stopped."
    exit 0
}
restart()
{
    echo "Restarting Wing Gateway daemon..."
    #pkill WingGateway & 1>/dev/null 2>&1
    GATEWAY_PID=\`ps -ef | grep \\.\\/WingGateway | grep -v grep | grep -v service | grep -v init.d | awk '{print \$2}'\`
    if [ ! -z "\$GATEWAY_PID" ]; then
       kill -9 \$GATEWAY_PID & 1>/dev/null 2>&1
    fi
    echo "Wing Gateway Stopped."
    cd $WING_HOME
    ulimit -c unlimited
    ulimit -n 65535
    ./WingGateway & 1>/dev/null 2>&1
    echo "Wing Gateway Started."
    exit 0
}

case "\$1" in
start)
    start
    ;;
stop)
    stop
    ;;
restart)
    restart
    ;;
*)
    echo "Usage: /etc/init.d/wgateway [start|stop|restart]"
    exit 0
    ;;
esac

EOF

chmod +x "$INITD_WGATEWAY" 1>/dev/null 2>&1


if [ -d "/etc/rc0.d" ]; then
set 0 1 6
for i in "$@"; do
	ln -s "$INITD_WGATEWAY" "/etc/rc$i.d/K01wgateway" 1>/dev/null 2>&1
done
set 2 3 4 5
for i in "$@"; do
	ln -s "$INITD_WGATEWAY" "/etc/rc$i.d/S99wgateway" 1>/dev/null 2>&1
done
else
set 0 1 6
for i in "$@"; do
	ln -s "$INITD_WGATEWAY" "/etc/init.d/rc$i.d/K01wgateway" 1>/dev/null 2>&1
done
set 2 3 4 5
for i in "$@"; do
	ln -s "$INITD_WGATEWAY" "/etc/init.d/rc$i.d/S99wgateway" 1>/dev/null 2>&1
done
fi


echo ""
echo "Wing Gateway has been installed successfully!"
echo "Use the following command to start/stop Wing Gateway service: /etc/init.d/wgateway [start|stop|restart]"
if [ -f "$SYSTEMD_WGATEWAY" ]; then
	chmod +x "/etc/rc.d/rc.local" 1>/dev/null 2>&1
	echo "Or use systemctl command like this: systemctl [start|stop|restart] wgateway.service"
fi

alert "Do you want to start Wing Gateway service now"
if [ "$?" -eq "0" ]
then
        if [ -f "$SYSTEMD_WGATEWAY" ]; then
		systemctl start wgateway.service 1>/dev/null 2>&1
        else
		cd $WING_HOME
		./WingGateway & 1>/dev/null 2>&1
        fi
fi
